/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.RequestBackpackInventoryContentsMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.util.CountAbbreviator;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class BackpackTooltipRenderer {
    private static final String BACKPACK_ITEM_NAME = "backpack";
    private static final int REFRESH_INTERVAL = 20;
    private static boolean shouldRefreshContents = true;
    private static long lastRequestTime = 0L;
    private static ContentsTooltipPart contentsTooltipPart;
    @Nullable
    private static UUID backpackUuid;

    private BackpackTooltipRenderer() {
    }

    public static void onWorldLoad(WorldEvent.Load event) {
        shouldRefreshContents = true;
        lastRequestTime = 0L;
    }

    public static void renderBackpackTooltip(RenderTooltipEvent.Pre event) {
        ItemStack backpack = event.getStack();
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (!(backpack.func_77973_b() instanceof BackpackItem) || !Screen.func_231173_s_() || player == null) {
            return;
        }
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            UUID newUuid = wrapper.getContentsUuid().orElse(null);
            if (backpackUuid == null && newUuid != null || backpackUuid != null && !backpackUuid.equals(newUuid)) {
                lastRequestTime = 0L;
                backpackUuid = newUuid;
                shouldRefreshContents = true;
            }
            BackpackTooltipRenderer.requestContents(player, wrapper);
            BackpackTooltipRenderer.refreshContents(wrapper, minecraft);
            List lines = backpack.func_82840_a((PlayerEntity)player, (ITooltipFlag)(minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            if (backpackUuid != null) {
                int multiplier = wrapper.getInventoryHandler().getStackSizeMultiplier();
                if (multiplier > 1) {
                    lines.add(new TranslationTextComponent("item.sophisticatedbackpacks.backpack.tooltip.stack_multiplier", new Object[]{new StringTextComponent(Integer.toString(multiplier)).func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(TextFormatting.GREEN));
                }
                BackpackTooltipRenderer.addEnergytooltip(wrapper, lines);
                BackpackTooltipRenderer.addFluidTooltip(wrapper, lines);
            }
            GuiHelper.renderTooltip(minecraft, event.getMatrixStack(), lines, event.getX(), event.getY(), contentsTooltipPart, event.getFontRenderer(), backpack);
            event.setCanceled(true);
        });
    }

    private static void addEnergytooltip(IBackpackWrapper wrapper, List<ITextComponent> lines) {
        wrapper.getEnergyStorage().ifPresent(energyStorage -> lines.add((ITextComponent)new TranslationTextComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".energy", new Object[]{new StringTextComponent(CountAbbreviator.abbreviate(energyStorage.getEnergyStored())).func_240699_a_(TextFormatting.WHITE)}).func_240699_a_(TextFormatting.RED)));
    }

    private static void addFluidTooltip(IBackpackWrapper wrapper, List<ITextComponent> lines) {
        wrapper.getFluidHandler().ifPresent(fluidHandler -> {
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                FluidStack fluid = fluidHandler.getFluidInTank(tank);
                if (fluid.isEmpty()) {
                    lines.add((ITextComponent)new TranslationTextComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".fluid_empty").func_240699_a_(TextFormatting.BLUE));
                    continue;
                }
                lines.add((ITextComponent)new TranslationTextComponent(TranslationHelper.translItemTooltip(BACKPACK_ITEM_NAME) + ".fluid", new Object[]{new StringTextComponent(CountAbbreviator.abbreviate(fluid.getAmount())).func_240699_a_(TextFormatting.WHITE), new TranslationTextComponent(fluid.getTranslationKey()).func_240699_a_(TextFormatting.BLUE)}));
            }
        });
    }

    private static void requestContents(ClientPlayerEntity player, IBackpackWrapper wrapper) {
        if (lastRequestTime + 20L < player.field_70170_p.func_82737_E()) {
            lastRequestTime = player.field_70170_p.func_82737_E();
            wrapper.getContentsUuid().ifPresent(uuid -> PacketHandler.sendToServer(new RequestBackpackInventoryContentsMessage((UUID)uuid)));
        }
    }

    private static void refreshContents(IBackpackWrapper wrapper, Minecraft minecraft) {
        if (shouldRefreshContents) {
            shouldRefreshContents = false;
            if (backpackUuid != null) {
                wrapper.onContentsNbtUpdated();
                List<ItemStack> sortedContents = InventoryHelper.getCompactedStacksSortedByCount((IItemHandler)wrapper.getInventoryHandler());
                contentsTooltipPart = new ContentsTooltipPart(minecraft, new TreeMap<Integer, IUpgradeWrapper>(wrapper.getUpgradeHandler().getSlotWrappers()), sortedContents);
            } else {
                contentsTooltipPart = BackpackTooltipRenderer.getEmptyInventoryTooltip(minecraft);
            }
        }
        if (contentsTooltipPart == null) {
            contentsTooltipPart = BackpackTooltipRenderer.getEmptyInventoryTooltip(minecraft);
        }
    }

    private static ContentsTooltipPart getEmptyInventoryTooltip(Minecraft minecraft) {
        return new ContentsTooltipPart(minecraft, new HashMap<Integer, IUpgradeWrapper>(), new ArrayList<ItemStack>());
    }

    public static void refreshContents() {
        shouldRefreshContents = true;
    }

    static {
        backpackUuid = null;
    }

    private static class ContentsTooltipPart
    implements GuiHelper.ITooltipRenderPart {
        private static final TextureBlitData UPGRADE_ON = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(81, 0), Dimension.RECTANGLE_4_10);
        private static final TextureBlitData UPGRADE_OFF = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(77, 0), Dimension.RECTANGLE_4_10);
        private static final int MAX_STACKS_ON_LINE = 9;
        private static final int DEFAULT_STACK_WIDTH = 18;
        private static final int COUNT_PADDING = 2;
        private final Minecraft minecraft;
        private final Map<Integer, IUpgradeWrapper> upgrades;
        private final List<ItemStack> backpackContents;
        private int height;
        private int width;

        public ContentsTooltipPart(Minecraft minecraft, Map<Integer, IUpgradeWrapper> upgrades, List<ItemStack> backpackContents) {
            this.minecraft = minecraft;
            this.upgrades = upgrades;
            this.backpackContents = backpackContents;
            this.calculateHeight();
            this.calculateWidth();
        }

        private void calculateWidth() {
            int contentsWidth;
            int upgradesWidth = this.calculateUpgradesWidth();
            int stacksWidth = Math.max(upgradesWidth, contentsWidth = this.calculateContentsWidth());
            this.width = stacksWidth > 0 ? stacksWidth : this.getEmptyTooltipWidth();
        }

        private int calculateUpgradesWidth() {
            int upgradesWidth = 0;
            for (IUpgradeWrapper upgradeWrapper : this.upgrades.values()) {
                upgradesWidth += (upgradeWrapper.canBeDisabled() ? 4 : 0) + 18;
            }
            return upgradesWidth;
        }

        private int calculateContentsWidth() {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int contentsWidth = 0;
            for (int i = 0; i < this.backpackContents.size() && i < 9; ++i) {
                int countWidth = this.getStackCountWidth(fontRenderer, this.backpackContents.get(i));
                contentsWidth += Math.max(countWidth, 18);
            }
            return contentsWidth;
        }

        private int getStackCountWidth(FontRenderer fontRenderer, ItemStack stack) {
            return fontRenderer.func_78256_a(CountAbbreviator.abbreviate(stack.func_190916_E())) + 2;
        }

        private void calculateHeight() {
            int upgradesHeight = this.upgrades.isEmpty() ? 0 : 32;
            int inventoryHeight = this.backpackContents.isEmpty() ? 0 : 12 + (1 + this.backpackContents.size() / 9) * 20;
            int totalHeight = upgradesHeight + inventoryHeight;
            this.height = totalHeight > 0 ? totalHeight : 12;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        private int getEmptyTooltipWidth() {
            return Minecraft.func_71410_x().field_71466_p.func_243245_a(new TranslationTextComponent("item.sophisticatedbackpacks.backpack.tooltip.empty").func_241878_f());
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(MatrixStack matrixStack, int leftX, int topY, FontRenderer font) {
            if (!this.upgrades.isEmpty()) {
                topY = this.renderTooltipLine(leftX, topY, matrixStack, font, "upgrades");
                topY = this.renderUpgrades(matrixStack, leftX, topY);
            }
            if (!this.backpackContents.isEmpty()) {
                topY = this.renderTooltipLine(leftX, topY, matrixStack, font, "inventory");
                this.renderContents(matrixStack, leftX, topY);
            }
            if (this.upgrades.isEmpty() && this.backpackContents.isEmpty()) {
                this.renderTooltipLine(leftX, topY, matrixStack, font, "empty");
            }
        }

        private int renderTooltipLine(int leftX, int topY, MatrixStack matrixStack, FontRenderer font, String tooltip) {
            IRenderTypeBuffer.Impl renderTypeBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            topY = GuiHelper.writeTooltipLines(Collections.singletonList(new TranslationTextComponent("item.sophisticatedbackpacks.backpack.tooltip." + tooltip).func_240699_a_(TextFormatting.YELLOW)), font, leftX, topY, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, -1);
            renderTypeBuffer.func_228461_a_();
            return topY;
        }

        private int renderUpgrades(MatrixStack matrixStack, int leftX, int topY) {
            int x = leftX;
            for (IUpgradeWrapper upgradeWrapper : this.upgrades.values()) {
                if (upgradeWrapper.canBeDisabled()) {
                    GuiHelper.blit(this.minecraft, matrixStack, x, topY + 3, upgradeWrapper.isEnabled() ? UPGRADE_ON : UPGRADE_OFF);
                    x += 4;
                }
                GuiHelper.renderItemInGUI(matrixStack, this.minecraft, upgradeWrapper.getUpgradeStack(), x, topY, true);
                x += 18;
            }
            return topY += 20;
        }

        private void renderContents(MatrixStack matrixStack, int leftX, int topY) {
            int x = leftX;
            for (int i = 0; i < this.backpackContents.size(); ++i) {
                int y = topY + i / 9 * 20;
                if (i % 9 == 0) {
                    x = leftX;
                }
                ItemStack stack = this.backpackContents.get(i);
                int stackWidth = Math.max(this.getStackCountWidth(this.minecraft.field_71466_p, stack), 18);
                int xOffset = stackWidth - 18;
                GuiHelper.renderItemInGUI(matrixStack, this.minecraft, stack, x + xOffset, y, true, CountAbbreviator.abbreviate(stack.func_190916_E()));
                x += stackWidth;
            }
        }
    }
}

